//AIM:Derive the 8 point twiddle factor matrix for computing inverse DFT

// i.e. W8* matrix derivation

//Software version Scilab 5.5.2
//OS windows 10
clc;
clear;
//Computing the twiddle factor values for W80,W81,W82,W83,W84,W85,W86,W87 :
W80=int(cos(0))+(sqrt(-1)*int(sin(0)));
W81=cos((2*%pi*1)/8)+(sqrt(-1))*sin((2*%pi*1)/8);
W82=int(cos((2*%pi*2)/8))+(sqrt(-1))*sin((2*%pi*2)/8);
W83=cos((2*%pi*3)/8)+(sqrt(-1))*sin((2*%pi*3)/8);
W84=cos((2*%pi*4)/8)+(sqrt(-1))*int(sin((2*%pi*4)/8));
W85=cos((2*%pi*5)/8)+(sqrt(-1))*sin((2*%pi*5)/8);
W86=int(cos((2*%pi*6)/8))+(sqrt(-1))*sin((2*%pi*6)/8);
W87=cos((2*%pi*7)/8)+(sqrt(-1))*sin((2*%pi*7)/8);

disp(W80,'W80=')
disp(W81,'W81=')
disp(W82,'W82=')
disp(W83,'W83=')
disp(W84,'W84=')
disp(W85,'W85=')
disp(W86,'W86=')
disp(W87,'W87=')

//W80=W88=W816=W824=W832=W840=W848;//Cyclic property of twiddle factor
W88=W80;
W816=W88;
W824=W816;
W832=W824;
W840=W832;
W848=W840;

//W81=W89=W817=W825=W833=W841=W849;//Cyclic property of twiddle factor
W89=W81;
W817=W89;
W825=W817;
W833=W825;
W841=W833;
W849=W841;

//W82=W810=W818=W826=W834=W842;//Cyclic property of twiddle factor
W810=W82;
W818=W810;
W826=W818;
W834=W826;
W842=W834;

//W83=W811=W819=W827=W835=W843;//Cyclic property of twiddle factor
W811=W83;
W819=W811;
W827=W819;
W835=W827;
W843=W835;

//W84=W812=W820=W828=W836=W844;//Cyclic property of twiddle factor
W812=W84;
W820=W812;
W828=W820;
W836=W828;
W844=W836;

//W85=W813=W821=W829=W837=W845;//Cyclic property of twiddle factor
W813=W85;
W821=W813;
W829=W821;
W837=W829;
W845=W837;

//W86=W814=W822=W830=W838=W846;//Cyclic property of twiddle factor
W814=W86;
W822=W814;
W830=W822;
W838=W830;
W846=W838;

//W87=W815=W823=W831=W839=W847;//Cyclic property of twiddle factor
W815=W87;
W823=W815;
W831=W823;
W839=W831;
W847=W839;

W8_star= [W80 W80 W80 W80 W80 W80 W80 W80;W80 W81 W82 W83 W84 W85 W86 W87;W80 W82 W84 W86 W88 W810 W812 W814;W80 W83 W86 W89 W812 W815 W818 W821;W80 W84 W88 W812 W816 W820 W824 W828;W80 W85 W810 W815 W820 W825 W830 W835;W80 W86 W812 W818 W824 W830 W836 W842;W80 W87 W814 W821 W828 W835 W842 W849];

disp(W8_star,'[W8*]=')
